import type { CliOptions } from '../cliRun.js';
import { type DefaultActionRunnerResult } from './defaultAction.js';
export declare const runRemoteAction: (repoUrl: string, options: CliOptions, deps?: {
    isGitInstalled: (deps?: {
        execAsync: typeof import("child_process").exec.__promisify__;
    }) => Promise<boolean>;
    execGitShallowClone: (url: string, directory: string, remoteBranch?: string, deps?: {
        execAsync: typeof import("child_process").exec.__promisify__;
    }) => Promise<void>;
}) => Promise<DefaultActionRunnerResult>;
export declare const formatGitUrl: (url: string) => string;
export declare const createTempDirectory: () => Promise<string>;
export declare const cloneRepository: (url: string, directory: string, remoteBranch?: string, deps?: {
    execGitShallowClone: (url: string, directory: string, remoteBranch?: string, deps?: {
        execAsync: typeof import("child_process").exec.__promisify__;
    }) => Promise<void>;
}) => Promise<void>;
export declare const cleanupTempDirectory: (directory: string) => Promise<void>;
export declare const copyOutputToCurrentDirectory: (sourceDir: string, targetDir: string, outputFileName: string) => Promise<void>;
//# sourceMappingURL=remoteAction.d.ts.map